<?php
require_once "auth.php"; require_login(); require_active();
$userId=(int)$_SESSION['user']['id'];

$stmt=$db->prepare("SELECT * FROM fotoyu_settings WHERE user_id=?");
$stmt->execute([$userId]);
$row=$stmt->fetch(PDO::FETCH_ASSOC) ?: [];

$api_url=$row['api_url'] ?? '';
$auth_type=$row['auth_type'] ?? 'none';
$bearer_token=$row['bearer_token'] ?? '';
$basic_username=$row['basic_username'] ?? '';
$basic_password=$row['basic_password'] ?? '';
$cookie_header=$row['cookie_header'] ?? '';
$csrf_header_name=$row['csrf_header_name'] ?? 'X-CSRF-TOKEN';
$csrf_token=$row['csrf_token'] ?? '';
$success_contains=$row['success_contains'] ?? '';

if ($_POST) {
  $api_url = trim($_POST['api_url'] ?? '');
  $auth_type = $_POST['auth_type'] ?? 'none';
  if (!in_array($auth_type, ['none','bearer','basic','cookie'], true)) $auth_type='none';
  $bearer_token = trim($_POST['bearer_token'] ?? '');
  $basic_username = trim($_POST['basic_username'] ?? '');
  $basic_password = trim($_POST['basic_password'] ?? '');
  $cookie_header = trim($_POST['cookie_header'] ?? '');
  $csrf_header_name = trim($_POST['csrf_header_name'] ?? 'X-CSRF-TOKEN');
  $csrf_token = trim($_POST['csrf_token'] ?? '');
  $success_contains = trim($_POST['success_contains'] ?? '');
  $now=date('c');

  if (!empty($row)) {
    $stmt=$db->prepare("UPDATE fotoyu_settings SET api_url=?,auth_type=?,bearer_token=?,basic_username=?,basic_password=?,cookie_header=?,csrf_header_name=?,csrf_token=?,success_contains=?,updated_at=? WHERE user_id=?");
    $stmt->execute([$api_url,$auth_type,$bearer_token,$basic_username,$basic_password,$cookie_header,$csrf_header_name,$csrf_token,$success_contains,$now,$userId]);
  } else {
    $stmt=$db->prepare("INSERT INTO fotoyu_settings (user_id,api_url,auth_type,bearer_token,basic_username,basic_password,cookie_header,csrf_header_name,csrf_token,success_contains,created_at,updated_at) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->execute([$userId,$api_url,$auth_type,$bearer_token,$basic_username,$basic_password,$cookie_header,$csrf_header_name,$csrf_token,$success_contains,$now,$now]);
  }
  $ok="Tersimpan.";
}
?>
<!doctype html>
<html lang="id"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Pengaturan Fotoyu</title>
<style>
body{font-family:system-ui,Arial,sans-serif;margin:18px;max-width:820px}
input,select,button,textarea{padding:10px 12px;width:100%;max-width:680px}
label{display:block;margin:10px 0 6px}
.card{border:1px solid #ddd;border-radius:12px;padding:14px}
.small{color:#666;font-size:12px}
.ok{color:green}
</style>
</head><body>
<h2>Pengaturan Upload ke Fotoyu</h2>
<p><a href="dashboard">Kembali</a> | <a href="logout">Logout</a></p>
<?php if(!empty($ok)) echo "<p class='ok'>".htmlspecialchars($ok)."</p>"; ?>

<div class="card">
<form method="post">
  <label>Fotoyu Upload URL (Request URL yang dipakai saat klik tombol Unggah di Fotoyu)</label>
  <input name="api_url" value="<?= htmlspecialchars($api_url) ?>" placeholder="contoh: https://fotoyu.com/api/upload" required>

  <label>Tipe Auth</label>
  <select name="auth_type" id="auth_type" onchange="toggleAuth()">
    <option value="none" <?= $auth_type==='none'?'selected':'' ?>>None</option>
    <option value="bearer" <?= $auth_type==='bearer'?'selected':'' ?>>Bearer Token</option>
    <option value="basic" <?= $auth_type==='basic'?'selected':'' ?>>Basic (username/password)</option>
    <option value="cookie" <?= $auth_type==='cookie'?'selected':'' ?>>Cookie Session (untuk situs yang butuh login + CSRF)</option>
  </select>

  <div id="bearer_box" style="display:none">
    <label>Bearer Token</label>
    <input name="bearer_token" value="<?= htmlspecialchars($bearer_token) ?>" placeholder="token...">
  </div>

  <div id="basic_box" style="display:none">
    <label>Basic Username</label>
    <input name="basic_username" value="<?= htmlspecialchars($basic_username) ?>">
    <label>Basic Password</label>
    <input type="password" name="basic_password" value="<?= htmlspecialchars($basic_password) ?>">
  </div>

  <div id="cookie_box" style="display:none">
    <label>Cookie Header (copy dari request upload Fotoyu) — format: key=value; key2=value2</label>
    <textarea name="cookie_header" rows="3" placeholder="contoh: fotoyu_session=...; XSRF-TOKEN=..."><?= htmlspecialchars($cookie_header) ?></textarea>

    <label>CSRF Header Name (jika diperlukan)</label>
    <input name="csrf_header_name" value="<?= htmlspecialchars($csrf_header_name) ?>" placeholder="contoh: X-CSRF-TOKEN">

    <label>CSRF Token Value (jika diperlukan)</label>
    <textarea name="csrf_token" rows="2" placeholder="token csrf..."><?= htmlspecialchars($csrf_token) ?></textarea>
  </div>

  <label>Validasi Sukses (opsional): teks yang HARUS ada di response agar dianggap sukses</label>
  <input name="success_contains" value="<?= htmlspecialchars($success_contains) ?>" placeholder='contoh: "success" atau ""ok":true"'>

  <div style="margin-top:12px"><button>Simpan</button></div>
</form>
</div>

<p class="small">
Kenapa foto tidak muncul di Fotoyu walau "HTTP 200"? Biasanya karena URL yang dipakai bukan endpoint upload asli,
atau server membalas HTML (redirect/login) tapi tetap status 200. Dengan mode Cookie+CSRF dan success check, kita bisa pastikan.
</p>

<script>
function toggleAuth(){
  const v=document.getElementById('auth_type').value;
  document.getElementById('bearer_box').style.display = (v==='bearer')?'block':'none';
  document.getElementById('basic_box').style.display  = (v==='basic')?'block':'none';
  document.getElementById('cookie_box').style.display = (v==='cookie')?'block':'none';
}
toggleAuth();
</script>
</body></html>
