<?php
require_once "config.php";
if ($_POST) {
    $username = trim($_POST['username'] ?? '');
    $email = strtolower(trim($_POST['email'] ?? ''));
    $pw = $_POST['password'] ?? '';
    if (strlen($pw) < 6) { $err = "Password min 6."; }
    else {
        try {
            $stmt = $db->prepare("INSERT INTO users (username,email,password,role,is_active) VALUES (?,?,?,?,?)");
            $stmt->execute([$username,$email,password_hash($pw, PASSWORD_DEFAULT),'user',0]);
            echo "Registrasi berhasil. Tunggu aktivasi admin.<br><a href='login'>Login</a>";
            exit;
        } catch(Exception $e) { $err="Username/email sudah dipakai."; }
    }
}
?>
<!doctype html><html lang="id"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Register</title></head>
<body>
<h2>Register</h2>
<p>Akun baru akan non-aktif sampai admin mengaktifkan.</p>
<?php if(!empty($err)) echo "<p style='color:red'>".htmlspecialchars($err)."</p>"; ?>
<form method="post">
  <input name="username" placeholder="Username" required><br><br>
  <input name="email" placeholder="Email" required><br><br>
  <input type="password" name="password" placeholder="Password (min 6)" required><br><br>
  <button>Daftar</button>
</form>
<p><a href="login">Login</a></p>
</body></html>
