<?php
require_once "auth.php"; require_login(); require_active();
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Camera Dashboard</title>
<style>
body{font-family:system-ui,Arial,sans-serif;margin:18px}
video{width:860px;max-width:100%;background:#000;border-radius:10px}
.row{display:flex;gap:10px;flex-wrap:wrap;align-items:center;margin:10px 0}
select,button{padding:8px 10px}
.err{color:#b00020}
.ok{color:#0a7a1f}
.small{color:#666;font-size:12px;max-width:920px}
.pill{padding:6px 10px;border:1px solid #ddd;border-radius:999px}
</style>
</head>
<body>
<h2>Camera Dashboard</h2>
<div class="row">
  <a href="logout">Logout</a>
  <a href="settings">Pengaturan Fotoyu</a>
  <?php if($_SESSION['user']['role']==='admin'): ?><a href="admin">Admin Panel</a><?php endif; ?>
  <span class="pill">User: <?= htmlspecialchars($_SESSION['user']['username']) ?></span>
</div>

<div class="row">
  <label>Kamera:
    <select id="cam"></select>
  </label>
  <button id="btnStart">Start</button>
  <button id="btnStop">Stop</button>
  <button id="btnSnap">Capture Foto</button>
  <span id="msg" class="err"></span>
  <span id="ok" class="ok"></span>
</div>

<video id="video" autoplay playsinline muted></video>
<canvas id="cv" style="display:none"></canvas>

<div class="small">
Alur Capture: (1) download ke perangkat, (2) upload ke Fotoyu melalui server.<br>
Kalau upload "sukses" tapi foto tidak muncul, buka <b>Pengaturan Fotoyu</b> dan pastikan URL upload yang benar (Request URL saat klik Unggah di Fotoyu),
serta isi Cookie/CSRF jika diperlukan.
</div>

<script>
let stream=null;
const camSel=document.getElementById('cam');
const video=document.getElementById('video');
const msg=document.getElementById('msg');
const ok=document.getElementById('ok');
const cv=document.getElementById('cv');

function setMsg(t){ msg.textContent=t||""; }
function setOk(t){ ok.textContent=t||""; }

async function primePermission(){
  try{ const tmp=await navigator.mediaDevices.getUserMedia({video:true,audio:false}); tmp.getTracks().forEach(t=>t.stop()); }catch(e){}
}
async function loadCams(){
  const devices=await navigator.mediaDevices.enumerateDevices();
  const cams=devices.filter(d=>d.kind==='videoinput');
  camSel.innerHTML="";
  cams.forEach((c,i)=>{
    const o=document.createElement('option');
    o.value=c.deviceId;
    o.textContent=c.label||`Camera ${i+1}`;
    camSel.appendChild(o);
  });
  if(cams.length===0){
    const o=document.createElement('option');
    o.value="";
    o.textContent="Tidak ada kamera terdeteksi";
    camSel.appendChild(o);
  }
}
function stop(){
  if(stream){ stream.getTracks().forEach(t=>t.stop()); stream=null; }
  video.srcObject=null;
}
async function start(){
  setMsg(""); setOk("");
  stop();
  const id=camSel.value;
  const constraints={audio:false, video: id ? {deviceId:{ideal:id}} : true};
  try{ stream=await navigator.mediaDevices.getUserMedia(constraints); }
  catch(e){
    try{ stream=await navigator.mediaDevices.getUserMedia({video:true,audio:false}); }
    catch(e2){ setMsg(e2.name+": "+(e2.message||"")); return; }
  }
  video.srcObject=stream;
  try{ await loadCams(); }catch{}
}

function downloadBlob(blob, filename){
  const a=document.createElement('a');
  const url=URL.createObjectURL(blob);
  a.href=url; a.download=filename;
  document.body.appendChild(a); a.click(); a.remove();
  setTimeout(()=>URL.revokeObjectURL(url), 1500);
}

async function uploadToServer(blob, filename){
  const fd=new FormData();
  fd.append('file', blob, filename);
  const res=await fetch('upload.php', {method:'POST', body:fd});
  const data=await res.json().catch(async ()=>({ok:false, error:'Bad JSON', raw: await res.text()}));
  if(!res.ok || !data.ok) throw new Error((data.reason || data.error || data.response || ('HTTP '+res.status)).toString());
  return data;
}

async function capture(){
  setMsg(""); setOk("");
  if(!stream){ setMsg("Start kamera dulu."); return; }
  const w=video.videoWidth||0, h=video.videoHeight||0;
  if(!w||!h){ setMsg("Video belum siap."); return; }

  cv.width=w; cv.height=h;
  cv.getContext('2d').drawImage(video,0,0,w,h);

  const ts=new Date().toISOString().replace(/[:.]/g,'-');
  const filename=`capture-${ts}.jpg`;

  cv.toBlob(async (blob)=>{
    if(!blob){ setMsg("Gagal membuat gambar."); return; }
    downloadBlob(blob, filename);
    try{
      setOk("Uploading ke Fotoyu...");
      const resp=await uploadToServer(blob, filename);
      console.log("Upload response:", resp);
      setOk("Upload sukses.");
    }catch(e){
      setOk("");
      setMsg("Upload gagal: "+(e.message||e));
      console.error(e);
    }
  }, 'image/jpeg', 0.92);
}

document.getElementById('btnStart').addEventListener('click', start);
document.getElementById('btnStop').addEventListener('click', stop);
document.getElementById('btnSnap').addEventListener('click', capture);

(async function init(){
  await primePermission();
  await loadCams();
  if(navigator.mediaDevices?.addEventListener){
    navigator.mediaDevices.addEventListener('devicechange', loadCams);
  }
})();
</script>
</body>
</html>
