<?php
require_once "auth.php"; require_login(); require_admin();

if (isset($_GET['activate'])) {
  $id=(int)$_GET['activate'];
  $stmt=$db->prepare("UPDATE users SET is_active=1 WHERE id=? AND role='user'");
  $stmt->execute([$id]);
}
if (isset($_GET['deactivate'])) {
  $id=(int)$_GET['deactivate'];
  $stmt=$db->prepare("UPDATE users SET is_active=0 WHERE id=? AND role='user'");
  $stmt->execute([$id]);
}
$users=$db->query("SELECT * FROM users ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html><html lang="id"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Admin</title></head>
<body>
<h2>Admin Panel</h2>
<p><a href="dashboard">Dashboard</a> | <a href="logout">Logout</a></p>
<table border="1" cellpadding="6" cellspacing="0">
<tr><th>ID</th><th>Username</th><th>Email</th><th>Role</th><th>Active</th><th>Aksi</th></tr>
<?php foreach($users as $u): ?>
<tr>
<td><?= (int)$u['id'] ?></td>
<td><?= htmlspecialchars($u['username']) ?></td>
<td><?= htmlspecialchars($u['email']) ?></td>
<td><?= htmlspecialchars($u['role']) ?></td>
<td><?= (int)$u['is_active'] ?></td>
<td>
<?php if($u['role']==='user'): ?>
<a href="?activate=<?= (int)$u['id'] ?>">Activate</a> |
<a href="?deactivate=<?= (int)$u['id'] ?>">Deactivate</a>
<?php else: ?>-<?php endif; ?>
</td>
</tr>
<?php endforeach; ?>
</table>
</body></html>
